/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe;

import javax.annotation.Nullable;
import net.minecraft.class_2561;

public class RecipeResult<T> {
    private static final RecipeResult<?> PASS = new RecipeResult(false);
    private final boolean success;

    public static <T> RecipeResult<T> pass() {
        return PASS;
    }

    public static <T> RecipeResult<T> success(@Nullable T result) {
        if (result == null) {
            return RecipeResult.pass();
        }
        return new Success<T>(result);
    }

    public static <T> RecipeResult<T> failure(class_2561 component) {
        return new Failure(component);
    }

    public static <T> RecipeResult<T> failure(String translationKey, Object ... params) {
        return RecipeResult.failure((class_2561)class_2561.method_43469((String)translationKey, (Object[])params));
    }

    public T getResult() {
        throw new UnsupportedOperationException("Cannot get result on failure");
    }

    public boolean hasError() {
        return false;
    }

    public class_2561 getMessage() {
        throw new UnsupportedOperationException("Cannot show error message on success");
    }

    private RecipeResult(boolean success) {
        this.success = success;
    }

    public boolean isSuccess() {
        return this.success;
    }

    private static class Success<T>
    extends RecipeResult<T> {
        private final T result;

        private Success(T result) {
            super(true);
            this.result = result;
        }

        @Override
        public T getResult() {
            return this.result;
        }
    }

    private static class Failure<T>
    extends RecipeResult<T> {
        private final class_2561 message;

        private Failure(class_2561 message) {
            super(false);
            this.message = message;
        }

        @Override
        public boolean hasError() {
            return true;
        }

        @Override
        public class_2561 getMessage() {
            return this.message;
        }
    }
}

